<?php
if(!class_exists('pw_pro_news_ticker'))
{
	class pw_pro_news_ticker
	{	
		
		public  $rand_id ,  $ticker_height , $ticker_border , $toggle_background , $toggle_color , $title_width ,  $title_background , $title_font ,  $clock_background , $clock_font , $content_background , $content_font , $meta_font , $icon_background , $icon_color , $nav_background, $nav_color , $custom_css , $user_css ;
		function __construct()
		{
			add_action('vc_before_init',array($this,'pw_pro_news_ticker_init'));
			add_shortcode('pw_VC_pro_news_ticker_shortcode',array($this,'pw_pro_news_ticker_shortcode'));
		}	
		
		
		public function get_category_tag( $id = 0, $taxonomy, $before = '', $sep = '', $after = '', $count='all', $exclude = array() ){
		$terms = get_the_terms( $id, $taxonomy );

		if ( is_wp_error( $terms ) )
			return $terms;
	
		if ( empty( $terms ) )
			return false;
	
		$counter=0;
		foreach ( $terms as $term ) {
			if($counter<$count || $count=='all'){	
				
				if(!in_array($term->term_id,$exclude)) {
					$link = get_term_link( $term, $taxonomy );
					if ( is_wp_error( $link ) )
						return $link;
					$term_links[] = '<a href="' . $link . '" rel="tag">' . $term->name . '</a>';
				}
				$counter++;
			}
		}
	
		$term_links = apply_filters( "term_links-$taxonomy", $term_links );
	
		return $before . join( $sep, $term_links ) . $after;
		}
		
		
		////////////excerpt
		public function excerpt($text,$excerpt_length,$content_type='excerpt') {
			global $post;
			if(trim($excerpt_length)=='') $excerpt_length=10;
			$limit=$excerpt_length;
			if($content_type=='excerpt')	
			{
				$excerpt = explode(' ', $text, $limit);
				if (count($excerpt)>=$limit) {
					array_pop($excerpt);
					$excerpt = implode(" ",$excerpt).'...';
				} else {
					$excerpt = implode(" ",$excerpt);
				}	
				$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
				return $excerpt;
			}
			else{
				$content = explode(' ', $text, $limit);
				if (count($content)>=$limit) {
					array_pop($content);
					$content = implode(" ",$content).'...';
				} else {
					$content = implode(" ",$content);
				}	
				//REMOVE SHORTCODE
				//$content = preg_replace('/\[.+\]/','', $content);
				
				$content = apply_filters('the_content', $content); 
				$content = str_replace(']]>', ']]&gt;', $content);
				return $content;
			}
		}

		function frontend_embed_pro_news_ticker($rtl)
		{
				/*Styles*/
				if ($rtl=='pl-rtl-ticker'){
					wp_enqueue_style(__PW_PRO_NEWS_TICKER_FIELDS_PERFIX__.'pw_pl_news_ticker_rtl');
				}
				
		}
		
		function pw_pro_news_ticker_init()
		{
			if(function_exists('vc_map'))
			{
				vc_map( array(
					"name" => __("PW News Ticker",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
					"description" => __("News Ticker",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
					"base" => "pw_VC_pro_news_ticker_shortcode",
					"class" => "",
					"controls" => "full",
					"icon" => __PW_PRO_NEWS_TICKER_ROOT_VC_URL__ .'/img/icon.png',
					"category" => __('PW Pro Post Layout', PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
					"params" => array(
									///////////////////////data base setting
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Ticker Source",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "ticker_soure",
										"value" => array(
											__("Build Query" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"build_query",
											__("RSS & Feed" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"rss",
											__("Manual Text" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"manual",											
											),
										"description" => __( 'Choose source of news ticker', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Source"
									),
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("News Ticker Base",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "ticker_base",
										"value" => array(
											__("Customize Query" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"all",
											__("Category" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"category_base",
											__("Tag" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"tag_base",
											__("Taxonomy" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"tax_base",											
											__("Author" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"author_base",											
											),
										"description" =>  __( 'Choose news ticker based on', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Source",
										'dependency' => array(
											'element' => 'ticker_soure',
											'value' => array( 'build_query')
										)
									),
									array(
										'type' => 'loop',
										'heading' => __( 'Your Query', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'param_name' => 'pw_query',
										'settings' => array(
										  'size' => array( 'hidden' => false, 'value' => 10 ),
										  'order_by' => array( 'value' => 'date' ),
										),
										'description' => __( 'Create WordPress loop, to populate content from your site.', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Source",
										'dependency' => array(
											'element' => 'ticker_soure',
											'value' => array( 'all','build_query')
										)
									),
									
									
									/******RSS*********/
									array(
										"type" => "exploded_textarea",
										"class" => "",
										"heading" => __("RSS/Feed Source",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'param_name' => 'rss_source',
										"value" => "",
										"description" => __( 'Use this pattern:<br /> RSS/Feed Name | RSS/Feed Link ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Source",
										'dependency' => array(
											'element' => 'ticker_soure',
											'value' => array( 'rss')
										)
									),
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Set RSS Source Images",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "set_rss_image",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"set_rss_image",
											),
										"description" => __( 'Set and show image for RSS sources', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Source",
										'dependency' => array(
											'element' => 'ticker_soure',
											'value' => array( 'rss')
										)
										
									),
									array(
										"type" => "attach_images",
										"class" => "",
										"heading" => __("RSS Item Images",  PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										"param_name" => "rss_images",
										"description" => __( 'Set image for each RSS Source', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Source",
										'dependency' => array(
											'element' => 'set_rss_image',
											'value' => array( 'set_rss_image')
										),
									),
									/******Manual Source*********/
									array(
										"type" => "exploded_textarea",
										"class" => "",
										"heading" => __("Manual Source",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'param_name' => 'manual_source',
										"value" => "",
										"description" => __( 'Use this pattern:<br /> Text Link(http://www.sample.com) | Text Content | Image Link ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Source",
										'dependency' => array(
											'element' => 'ticker_soure',
											'value' => array( 'manual')
										)
									),
									
									
									/*******************************************
									*************TICKER SETTING TAB*************
									*******************************************/
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Ticker Direction Mode",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "ticker_mode",
										"value" => array(
											__("Horizontal" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-horizontal-ticker",
											__("Vertical" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-vertical-ticker",
											),
										"description" => __( 'Choose ticker direction mode', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting"
									),
									
									array(
										"type" => "pw_image_radio",
										"class" => "",
										"heading" => __("Vertical Items Layout"),
										"param_name" => "vertical_item_layout",
										"value" =>array(
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/mini-item-l1.png'."' />"=>"pl-vitem-layout-1",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/mini-item-l2.png'."' />"=>"pl-vitem-layout-5",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/mini-item-l3.png'."' />"=>"pl-vitem-layout-2",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/mini-item-l4.png'."' />"=>"pl-vitem-layout-3",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/mini-item-l5.png'."' />"=>"pl-vitem-layout-4",
									),
										"description" => __("Choose Vertical Items Layout", PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'ticker_mode',
											'value' => array( 'pl-vertical-ticker')
										)
									),
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Ticker Height", PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "ticker_height",
										"value" =>'50',
										"description" =>  __("Enter ticker height base on Pixle", PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'ticker_mode',
											'value' => array( 'pl-horizontal-ticker')
										)
										
									),
									
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Enable Interval",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "enable_interval",
										'group' => "Ticker Setting",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"enable_interval",
											),
										"description" => __( 'Do you want to enable interval ?', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
									),
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Refresh Time", PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "ticker_interval",
										"value" =>'10',
										"description" =>  __("Enter ticker refresh time base on minutes", PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'enable_interval',
											'value' => array( 'enable_interval')
										),
									),
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Enable RTL",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "enable_rtl",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-rtl-ticker",
											),
										"description" =>  '',
										'group' => "Ticker Setting",
									),
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Ticker Position",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "ticker_pos",
										"value" => array(
											__("Current Place" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-current-wrapper",
											__("Fix Top " ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-fixed-wrapper pl-fix-top",
											__("Fix Bottom " ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-fixed-wrapper pl-fix-bottom",
											),
										"description" => '', 
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'ticker_mode',
											'value' => array( 'pl-horizontal-ticker')
										)
									),
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Show Ticker Title",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "hide_title",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"show_title",
											__("No, Thanks" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"hide_title",
											),
										"description" => '' ,
										'group' => "Ticker Setting"
									),
									array(
										"type" => "textfield",
										"class" => "",
										"heading" => __("Title Text",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "title_text",
										"value" => "",
										"description" =>__( 'Text of ticker title area', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'hide_title',
											'value' => array( 'show_title')
										),
										
									),
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Title Width", PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "title_width",
										"value" =>'150',
										"description" =>  __("Enter width of ticker title", PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'hide_title',
											'value' => array( 'show_title')
										),
										
									),
									
									array(
										"type" => "pw_fontawesome",
										
										"class" => "",
										"heading" => __("Title Icon", PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										"param_name" => "title_icon",
										"description" => __("Choose ticker title icon", PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'hide_title',
											'value' => array( 'show_title')
										),
									),
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Open Links On New Tab?",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "open_link_new",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"_blank",
											),
										"description" => __( 'Open ticker links on new tab', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'ticker_soure',
											'value' => array( 'rss', 'build_query')

										),
									),
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Filter",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_filter",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"show_filter",
											),
										"description" => __( 'The dropdown under ticker title', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'ticker_soure',
											'value' => array( 'rss', 'build_query')

										),
									),
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Author Image",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_author_image",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"show_author_image",
											),
										"description" => __( 'The image of author on dropdown under ticker title when query is base on author', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'ticker_base',
											'value' => array( 'author_base')
										),
									),
									
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Refresh Time Area",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_time",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-timer-enable",
											),
										"description" => __( 'Hide / Show refresh time area', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting"
										
									),
									
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Toggle Button",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_toggle",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"show_toggle",
											),
										"description" => __( 'Hide / Show toggle(close) button under ticker', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting"
										
									),
									
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Post Image",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_post_image",
										"value" => array(
											__("Yes, Of Course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"show_post_image",
											),
										"description" => __( 'The image of post on ticker horizontal mode.<br /> On vertical slider image always shown', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting",
										
									),
									
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Image Style",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "post_image_style",
										"value" => array(
											__("Round" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-round-img",
											__("square" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-square-img",
											),
										"description" => '',
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'show_post_image',
											'value' => array( 'show_post_image')
										),
									),
									array(
										"type" => "attach_image",
										"class" => "",
										"heading" => __("Default Image",  PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										"param_name" => "default_image",
										"description" => __( 'Default image when tick no any image', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'show_post_image',
											'value' => array( 'show_post_image')
										),
									),
									
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Date",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_date",
										"value" => array(
											__("Yes" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"yes"										
										),
										"description" =>  '',
										'group' => "Ticker Setting",
									),
										/*date item*/
										array(
											"type" => "textfield",
											"class" => "",
											"heading" => __("Date Format",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
											"param_name" => "date_format",
											"value" => "",
											"description" => __( 'Use from wordpress date format refrence', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
											'group' => "Ticker Setting",
											'dependency' => array(
												'element' => 'show_date',
												'value' => array( 'yes' )
											)
										),
										
									
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Sharing",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_sharing",
										"value" => array(
											__("Yes" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"show_sharing"										
										),
										"description" => '',
										'group' => "Ticker Setting",
									),
										/*Share item*/
										array(
											"type" => "checkbox",
											"class" => "",
											"heading" => __("Social Shares",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
											"param_name" => "social_icons",
											"value" => array(
												__("Facebook" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"share_facebook",
												__("Twitter" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"share_twitter",
												__("Google" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"share_google"	
											),
											"description" =>'' ,
											'group' => "Ticker Setting",
											'dependency' => array(
												'element' => 'show_sharing',
												'value' => array( 'show_sharing' )
											)
										),
										
									
									
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Quick View",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_quick",
										"value" => array(
											__("Yes" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"show_quick"										
										),
										"description" => __( 'Show quick view icon ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Ticker Setting",
									),
										/*Quick View Effect*/
										array(
											"type" => "dropdown",
											"class" => "",
											"heading" => __("Quick View Display Effect",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
											"param_name" => "quick_effect",
											"value" => array(
												__("Fade In Scale" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"fade-in-scale",
												__("Slide In Top" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"slide-in-top",
												__("Flip h 3d" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"flip-h-3d",
												__("Rotate Carouse Left" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"rotate-carouse-left",
												__("Zoom In" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"mfp-zoom-in",
												__("Zoom Out" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"mfp-zoom-out",
												__("Newspaper" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"mfp-newspaper",
												__("Move Horizontal" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"mfp-move-horizontal",
												__("3d Unfold" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"mfp-3d-unfold",
																								
												),
											"description" => '',
											'group' => "Ticker Setting",
											'dependency' => array(
												'element' => 'show_quick',
												'value' => array( 'show_quick' )
											)
										),
									
									
									/*Meta*/
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Show Metas",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_meta",
										"value" => array(
											__("No, Thanks" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"no",
											__("Yes, of course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"yes",
											),
										"description" => '',
										'group' => "Ticker Setting",
										'dependency' => array(
												'element' => 'ticker_mode',
												'value' => array( 'pl-vertical-ticker' )
											)
									),
									/*Meta Items*/
																	
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Author",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_author",
										"value" => array(
											__("Yes" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"yes"										
										),
										"description" => '',
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'show_meta',
											'value' => array( 'yes' )
										)
									),
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Comments",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_comments",
										"value" => array(
											__("Yes" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"yes"										
										),
										"description" => '',
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'show_meta',
											'value' => array( 'yes' )
										)
									),
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show category",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_category",
										"value" => array(
											__("Yes" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"yes"										
										),
										"description" => '',
										'group' => "Ticker Setting",
										'dependency' => array(
											'element' => 'show_meta',
											'value' => array( 'yes' )
										)
									),
										/*category item*/
										array(
											"type" => "pw_number",
											"class" => "",
											"heading" => __("Category Number", PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
											"param_name" => "cat_number",
											"value" =>'1',
											"description" => '',
											'group' => "Ticker Setting",
											'dependency' => array(
												'element' => 'show_category',
												'value' => array( 'yes' )
											)
										),
									
									/*Excerpt*/
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Show Excerpt",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_excerpt",
										"value" => array(
											__("No, Thanks" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"no",
											__("Yes, of course" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"yes",
											),
										"description" => '',
										'group' => "Ticker Setting",
										'dependency' => array(
												'element' => 'ticker_mode',
												'value' => array( 'pl-vertical-ticker' )
											)
									),
										/*Excerpt Items*/
										array(
											"type" => "dropdown",
											"class" => "",
											"heading" => __("Excerpt Source",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
											"param_name" => "excerpt_source",
											"value" => array(
												__("Excerpt" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"excerpt",
												__("Full Content" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"full_content",
												),
											"description" => '',
											'group' => "Ticker Setting",
											"dependency" => array(
												'element' => 'show_excerpt',
												'value' => array( 'yes' )
											)
										),
										array(
											"type" => "pw_number",
											"class" => "",
											"heading" => __("Excerpt Lenght",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
											"param_name" => "excerpt_len",
											"value" => "",
											"description" => '',
											'group' => "Ticker Setting",
											'dependency' => array(
												'element' => 'show_excerpt',
												'value' => array( 'yes' )
											)
										),
										
									
									/*****************************************************
									****************Ticker Movement Option****************
									*****************************************************/
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Ticker Move Effect",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "carousel_effect",
										"value" => array(
											__("Slide Base On Ticker Mode" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"slide",
											__("Fade" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"fade",
											__("Marquee" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"marquee",
											),
										"description" => __( 'Do not use fade effect on vertical ticker mode', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Movement Option",
									),
									array(
										"type" => "dropdown",
										"class" => "",
										"heading" => __("Marquee Direction",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "marquee_direction",
										"value" => array(
											__("Left" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"left",
											__("Right" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"right",
											__("Up" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"up",
											__("Down" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"down",
											),
										"description" => __( 'Don not use left and right direction for vertical ticker mode ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Movement Option",
										'dependency' => array(
											'element' => 'carousel_effect',
											'value' => array( 'marquee' )
										)
									),
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Scroll Amount",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "scroll_amount",
										"value" => "20",
										"description" => __( 'Enter value base on px ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Movement Option",
										'dependency' => array(
											'element' => 'carousel_effect',
											'value' => array( 'marquee' )
										)
									),
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Marquee Height",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "marquee_height",
										"value" => "200",
										"description" => __( 'Enter value base on px ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Movement Option",
										'dependency' => array(
											'element' => 'marquee_direction',
											'value' => array( 'up','down' )
										)
									),
									array(
										"type" => "checkbox",
										"class" => "",
										"heading" => __("Show Navigation",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "show_navigation",
										"value" => array(
											__("Yes" ,  PW_PRO_NEWS_TICKER_TEXTDOMAIN  )=>"pl-ticker-show-nav"										
										),
										"description" => '',
										'group' => "Movement Option",
										'dependency' => array(
											'element' => 'carousel_effect',
											'value' => array( 'slide' , 'fade' )
										)
									),
									
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Autoplay Speed",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "auto_speed",
										"value" => "2000",
										"description" => __( 'Enter value base on milli second ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Movement Option",
										'dependency' => array(
											'element' => 'carousel_effect',
											'value' => array( 'slide' , 'fade' )
										)
									),
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Pause Time",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "trans_speed",
										"value" => "2000",
										"description" => __( 'Enter value base on milli second ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Movement Option",
										'dependency' => array(
											'element' => 'carousel_effect',
											'value' => array( 'slide' , 'fade' )
										)
									),
									
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Items",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "item_per_show",
										"value" => "3",
										"description" => '',
										'group' => "Movement Option",
										'dependency' => array(
												'element' => 'ticker_mode',
												'value' => array( 'pl-vertical-ticker' )
											)
									),
									array(
										"type" => "pw_number",
										"class" => "",
										"heading" => __("Item(s) Per Slide",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "item_per_slide",
										"value" => "1",
										"description" => '',
										'group' => "Movement Option",
										'dependency' => array(
												'element' => 'ticker_mode',
												'value' => array( 'pl-vertical-ticker' )
											)
									),
									
									/*****************************************************
									****************Ticker Movement Option****************
									*****************************************************/
									
									array(
										"type" => "pw_border_option",
										"class" => "",
										"heading" => __("<div class='pl-main-heading'><span>Main Ticker Style</span></div>Ticker Border",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "ticker_border",
										"value" => '',
										"description" => __("Set Border Of Ticker",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										
									),
									
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("Toggle Background Color",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "toggle_background",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										'dependency' => array(
											'element' => 'show_toggle',
											'value' => array( 'show_toggle' )
										)
									),
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("Toggle Text Color",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "toggle_color",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										'dependency' => array(
											'element' => 'show_toggle',
											'value' => array( 'show_toggle' )
										)
									),
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("<div class='pl-main-heading'><span>Ticker Title Style </span></div>Title Background Color",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "title_background",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										'dependency' => array(
											'element' => 'hide_title',
											'value' => array( 'show_title')
										)
									),
									array(
										"type" => "pw_simple_font",
										"class" => "",
										"heading" => __("Title Font",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "title_font",
										"value" => "",
										"description" => "",
										'group' => "Styling",
										'dependency' => array(
											'element' => 'hide_title',
											'value' => array( 'show_title')
										)
									),			
									array(
										"type" => "pw_image_radio",
										"class" => "",
										"heading" => __("Title Layout"),
										"param_name" => "title_layout",
										"value" =>array(
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/title-layout1.jpg'."' />"=>"pl-ticker-title-l1",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/title-layout2.jpg'."' />"=>"pl-ticker-title-l2",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/title-layout3.jpg'."' />"=>"pl-ticker-title-l3",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/title-layout4.jpg'."' />"=>"pl-ticker-title-l4",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/title-layout5.jpg'."' />"=>"pl-ticker-title-l5",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/title-layout6.jpg'."' />"=>"pl-ticker-title-l6",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/title-layout7.jpg'."' />"=>"pl-ticker-title-l7",
											"<img src='".__PW_PRO_NEWS_TICKER_ROOT_VC_URL__.'/img/title-layout8.jpg'."' />"=>"pl-ticker-title-l8",
									),
										"description" => __("Choose ticker title layout", PW_PRO_NEWS_TICKER_TEXTDOMAIN ),
										'group' => "Styling",
										'dependency' => array(
											'element' => 'hide_title',
											'value' => array( 'show_title')
										)
									),
									
									/*clock area style*/
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("<div class='pl-main-heading'><span>Clock Area Style </span></div>Clock Background Color",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "clock_background",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										'dependency' => array(
											'element' => 'show_time',
											'value' => array( 'pl-timer-enable' )
										)
									),
									array(
										"type" => "pw_simple_font",
										"class" => "",
										"heading" => __("Clock Area Font",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "clock_font",
										"value" => "",
										"description" => "",
										'group' => "Styling",
										'dependency' => array(
											'element' => 'show_time',
											'value' => array( 'pl-timer-enable' )
										)
									),			
									
									/*content area style*/
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("<div class='pl-main-heading'><span>Ticker Content Style </span></div>Content Background Color",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "content_background",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										
									),
									array(
										"type" => "pw_adv_font",
										"class" => "",
										"heading" => __("content Font",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "content_font",
										"value" => "",
										"description" => "",
										'group' => "Styling",
										
									),			
									
									array(
										"type" => "pw_adv_font",
										"class" => "",
										"heading" => __("meta Font",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "meta_font",
										"value" => "",
										"description" =>__("When using vertical mode change this setting",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										'dependency' => array(
											'element' => 'show_meta',
											'value' => array( 'yes' )
										)
									),			
									
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("Icons Background Color",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "icon_background",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										
									),
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("Icon Color",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "icon_color",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										
									),
									
									/*Carousel style*/
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("Navigation Background",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "nav_background",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										'dependency' => array(
											'element' => 'show_navigation',
											'value' => array( 'pl-ticker-show-nav' )
										)
									),
									array(
										"type" => "colorpicker",
										"class" => "",
										"heading" => __("Navigation Color",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "nav_color",
										"value" => '',
										"description" => __("Leave blank to ignore",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'group' => "Styling",
										'dependency' => array(
											'element' => 'show_navigation',
											'value' => array( 'pl-ticker-show-nav' )
										)
									),
									array(
										"type" => "textfield",
										"class" => "",
										"heading" => __("Custom Class",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										"param_name" => "custom_css",
										"value" => "",
										"description" => "",
										'group' => "Styling"
									),

									
									/*******************************
									**********CUSTOM CSS/JS*********
									*******************************/	
									array(
										"type" => "textarea",
										"class" => "pl-user-css",
										"heading" => __("Custom CSS",  PW_PRO_NEWS_TICKER_TEXTDOMAIN  ),
										'param_name' => 'user_css',
										"value" => "",
										"description" => __( 'Type your custom CSS here ', PW_PRO_NEWS_TICKER_TEXTDOMAIN   ),
										'group' => "Custom CSS",
									),
									
																		
								)
					) );
			}
		}
		// Shortcode handler function for  icon block
		function pw_pro_news_ticker_shortcode($atts)
		{
			$ticker_soure=
			$ticker_base=
			$pw_query=
			$rss_source=
			$set_rss_image=
			$rss_images=
			
			$manual_source=
			
			//ticker setting tab
			$ticker_mode =
			$vertical_item_layout=
			$ticker_height=
			$enable_interval=
			$ticker_interval=
			$enable_rtl=
			$ticker_pos=
			$hide_title=
			$title_text=
			$title_width=
			$title_icon=
			$open_link_new=
			$show_filter=
			
			$show_author_image=
			$show_time =
			$show_toggle=
			$show_post_image=
			$post_image_style=
			$default_image= 
			
			$show_date=
			$date_format=
			
			$show_sharing=
			$social_icons=
			
			$show_quick=
			$quick_effect=
			
			$show_meta =
			$show_author =
			$show_comments =
			$show_category =
			$cat_number =
			
			$show_excerpt =
			$excerpt_source =
			$excerpt_len =
			
			//carousel setting Tab
			$carousel_effect=
			$marquee_direction=
			$scroll_amount=
			$marquee_height=
			$show_navigation=
			$auto_speed =
			$trans_speed=
			$item_per_show=
			$item_per_slide=
			
			//Style Tab
			
			$ticker_border=
			$toggle_background =
			$toggle_color = 
			
			$title_background=
			$title_font=
			$title_layout=
			
			$clock_background=
			$clock_font=
			
			$content_background=
			$content_font=
			$meta_font=
			$icon_background=
			$icon_color=
			$nav_background=
			$nav_color =
			$custom_css=
			$user_css=
			$output='';
			
			extract(shortcode_atts( array(
				'ticker_soure'=>'build_query',
				'ticker_base'=>'all',
				'pw_query'=>'',
				'rss_source'=>'',
				'set_rss_image'=>'hide_rss_image',
				'rss_images'=>'',
				'manual_source'=>'',
				
				
				//ticker setting tab
				'ticker_mode'=>'pl-horizontal-ticker',
				'vertical_item_layout'=>'pl-vitem-layout-1',
				'ticker_height'=>'50',
				'enable_interval'=>'disable_interval',
				'ticker_interval'=>'10',
				'enable_rtl'=>'pl-ltr-ticker',
				'ticker_pos'=>'pl-current-wrapper',
				'hide_title'=>'show_title',
				'title_text'=>'Breaking News',
				'title_width'=>'150',
				'title_icon'=>'fa-none',
				'open_link_new'=>'_self',
				'show_filter'=>'hide_filter',
				
				'show_author_image'=>'hide_author_image',
				'show_time'=>'pl-timer-disable',
				'show_toggle'=>'hide_toggle',
				'show_post_image'=>'hide_post_image',
				'post_image_style'=>'pl-round-img',
				'default_image'=>'',
				
				'show_date'=>'hide_date',
				'date_format'=>'j F Y',
				
				'show_sharing'=>'hide_date',
				'social_icons'=>'',
				
				'show_quick'=>'hide_quick',
				'quick_effect'=>'fade-in-scale',
				
				'show_meta'=>'no',
				'show_author'=>'no',
				'show_comments'=>'no',
				'show_category'=>'no',
				'cat_number'=>'1',
				
				'show_excerpt'=>'no',
				'excerpt_source'=>'excerpt',
				'excerpt_len'=>'20',
				
				
				//carousel setting
				'carousel_effect'=>'slide',
				'marquee_direction'=>'left',
				'scroll_amount'=>'20',
				'marquee_height'=>'200',
				'show_navigation'=>'pl-ticker-hide-nav',
				'auto_speed'=>'2000',
				'trans_speed'=>'2000',
				'item_per_show'=>'3',
				'item_per_slide'=>'1',
				
				
				//Style Tab
			
				'ticker_border'=>'0,0,0,0,solid,#dddddd',
				'toggle_background' => '#444',
				'toggle_color' => '#fff',
				
				'title_background'=>'#444444',
				'title_font'=>'inherit,15,#ffffff',
				'title_layout'=>'pl-ticker-title-l1',
				
				'clock_background'=>'#333333',
				'clock_font'=>'inherit,15,#f5f5f5',
				
				'content_background'=>'#777777',
				'content_font'=>'inherit,15,#f5f5f5,#f5f5f5',
				'meta_font'=>'inherit,11,#f5f5f5,#f5f5f5',
				'icon_background'=>'#444444',
				'icon_color'=>'#ffffff',
				
				'nav_background' => '#444',
				'nav_color' => '#fff',
				
				'custom_css'=>'',	
				'user_css'=>'',
				),$atts));
			
      
			$this->frontend_embed_pro_news_ticker($enable_rtl);

			$this->rand_id=rand(0,1000);

			if ($ticker_soure=='build_query'){
				if ($pw_query==''){
					$pw_query='size:5|order_by:date|order:ASC|post_type:posts';
				}
				$this->rand_id=rand(0,1000);
				unset($atts['user_css']);
				$output.="<form style='display:none' class='pw_ticker_form_".$this->rand_id."'><input name='pw_atts' value=
				'".json_encode($atts)."' /><input name='pw_rand_id' value=
				'".$this->rand_id."' /></form>";

				include("build_query_ticker.php");

			}
			else if  ($ticker_soure=='rss'){

				$this->rand_id=rand(0,1000);
				unset($atts['user_css']);
				$output.="<form style='display:none' class='pw_ticker_form_".$this->rand_id."'><input name='pw_atts' value=
				'".json_encode($atts)."' /><input name='pw_rand_id' value=
				'".$this->rand_id."' /></form>";

				include("rss_ticker.php");
			}
			else {
				include_once( ABSPATH . WPINC . '/feed.php' );
				include("manual_ticker.php");
			}

			$this->ticker_height = $ticker_height;
			$this->ticker_border = explode (',',$ticker_border);

			$this->toggle_background = $toggle_background;
			$this->toggle_color = $toggle_color;

			$this->title_width = $title_width;
			$this->title_background = $title_background;
			$this->title_font = explode (',' , $title_font);

			$this->clock_background = $clock_background;
			$this->clock_font = explode (',' , $clock_font);

			$this->content_background = $content_background;
			$this->content_font = explode (',' , $content_font);
			$this->meta_font = explode (',' , $meta_font);
			$this->icon_background = $icon_background;
			$this->icon_color = $icon_color;

			$this->nav_background = $nav_background;
			$this->nav_color = $nav_color;

			$this->custom_css=$custom_css;
			$this->user_css=$user_css;

			$this->pl_ticker_custom_css();
			return $output;	
		}
		
		function pl_ticker_custom_css()  {
			$inline_css='';
			$imported_font = $title_font = $content_font =$clock_font = $meta_font = array('inherit');
			$font_counter = 0;
			if ($this->title_font[0]!='inherit') {
				$imported_font[$font_counter++] = $this->title_font[0]; 
				$title_font = explode(':',str_replace('+',' ',$this->title_font[0]));
				
			} 
			if ($this->clock_font[0]!='inherit') {
				$imported_font[$font_counter++] = $this->clock_font[0]; 
				$clock_font = explode(':',str_replace('+',' ',$this->clock_font[0]));
			} 
			if ($this->content_font[0]!='inherit') {
				$imported_font[$font_counter++] = $this->content_font[0]; 
				$content_font = explode(':',str_replace('+',' ',$this->content_font[0]));
			} 
			if ($this->meta_font[0]!='inherit') {
				$imported_font[$font_counter++] = $this->meta_font[0]; 
				$meta_font = explode(':',str_replace('+',' ',$this->meta_font[0]));
			} 
			
			$imported_font= array_filter(array_unique($imported_font));
			
			$sep='|';$font_family='';
			foreach ( $imported_font as $font ){
				if ($font_family==''){$sep='';}
				if ($font!='inherit')
					$font_family .= $sep . $font;
				$sep='|';
			}
			
			wp_enqueue_style('pw-custom-css', __PW_PRO_NEWS_TICKER_ROOT_VC_URL__ . '/css/custom-css.css', array() , null); 
			if (($imported_font[0]!='inherit')){
				$inline_css .= '
			    @import url(http://fonts.googleapis.com/css?family='. $font_family.');
						   ';
			}//end if
			
			$inline_css.='
				/*Heading Main Color*/
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt {
					border-style:'.$this->ticker_border[4].';
					border-top-width:'.$this->ticker_border[0].'px;
					border-right-width:'.$this->ticker_border[1].'px;
					border-bottom-width:'.$this->ticker_border[2].'px;
					border-left-width:'.$this->ticker_border[3].'px;
					
					border-color:'.$this->ticker_border[5].';
					
				}
				
				.main-ticker-'.$this->rand_id.' .pl-ticker-close i{
					background-color: '.$this->toggle_background.';
					color:'. $this->toggle_color .';
				}
				
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt {
					height:'.$this->ticker_height.'px;
				}
				
				.main-ticker-'.$this->rand_id.' .pl-title-time{
					line-height:'.$this->ticker_height.'px;
				}
				
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt{';
					
					$inline_css .=($this->title_font[0] !='inherit')?'font-family:"'.$title_font[0].'"!important;':'';
				$inline_css.='
					background-color: '.$this->title_background.';
					color:'. $this->title_font[2] .';
					font-size:'. $this->title_font[1] .'px;
				}
				
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt.pl-ticker-title-l4:before,
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt.pl-ticker-title-l5:before{
					border-color: transparent transparent transparent '.$this->title_background.';
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt.pl-ticker-title-l5:before{
					border-width: '.($this->ticker_height/2).'px 0 '.($this->ticker_height/2).'px 25px;
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt.pl-ticker-title-l6:before,
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt.pl-ticker-title-l7:before{
					height: '.$this->ticker_height.'px;
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt.pl-ticker-title-l6:before,
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt.pl-ticker-title-l7:before{
					background-color:'.$this->title_background.';
				}
				.main-ticker-'.$this->rand_id.' .pl-title-menu li {
					background-color: '.$this->title_background.';
					color:'. $this->title_font[2] .';
					border-color:'.$this->title_font[2].';
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-title-cnt {
					width:'.$this->title_width.'px;
				}';
				
				/*Clock Style*/
				$inline_css.='
				.main-ticker-'.$this->rand_id.' .pl-title-time{';
					
					$inline_css .=($this->clock_font[0] !='inherit')?'font-family:"'.$clock_font[0].'"!important;':'';
				$inline_css.='
					background-color: '.$this->clock_background.';
					color:'. $this->clock_font[2] .';
					font-size:'. $this->clock_font[1] .'px;
				}';
				
				/*Content Style*/
				$inline_css.='
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt{
					background-color: '.$this->content_background.';
				}
				
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-title a , 
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-title{';
					
					$inline_css .=($this->content_font[0] !='inherit')?'font-family:"'.$content_font[0].'"!important;':'';
				$inline_css.='
					color:'. $this->content_font[2] .';
					font-size:'.$this->content_font[1].'px;
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-title a:hover,
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-title:hover{
					color:'.$this->content_font[3] .';
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-loading , 
				.main-ticker-'.$this->rand_id.' .pl-bloading {
					color:'.$this->content_font[3] .';
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-date span,
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-share-cnt i.fa-share-alt ,
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-share-cnt .pl-share-icons,
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-quick-cnt i.fa-file-text-o,
				.main-ticker-'.$this->rand_id.' .pl-vitem-item .pl-zoom-quick-btn > a{
					color:'. $this->icon_color .';
					background-color:'.$this->icon_background.';
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-share-cnt .pl-share-icons i{
					color:'. $this->icon_color .';
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt  .pl-ticker-img img{
					border-color:'.$this->icon_background.';
				}
				
				/*Meta Styles*/
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-meta .pl-meta-item , 
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-meta .pl-meta-item a,
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-meta .pl-meta-item .meta-text,
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-excerpt,
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-excerpt p
				{';
					
					$inline_css .=($this->meta_font[0] !='inherit')?'font-family:"'.$meta_font[0].'"!important;':'';
				$inline_css.='
					color:'. $this->meta_font[2] .';
				}
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-meta .pl-meta-item i{
					color:'. $this->meta_font[2] .';
				} 
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-meta .pl-meta-item a:hover, 
				.main-ticker-'.$this->rand_id.' .pl-ticker-cnt .pl-meta .pl-meta-item:hover i
				{
					color:'.$this->meta_font[3] .';
				}
				.main-ticker-'.$this->rand_id.' .bx-controls-direction a{
					background-color: '.$this->nav_background.';
					color:'. $this->nav_color .';
				}
				';
			
			$inline_css .= strip_tags($this->user_css);
				
			wp_add_inline_style( 'pw-custom-css', $inline_css );
		}
	}
	////instantiate the class
}
//new pw_pro_news_ticker();
$GLOBALS['pw_pro_news_ticker'] = new pw_pro_news_ticker;
?>